/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/***********************************************************************
 * File name     : board.h
 * board properties and generic functions
 ***********************************************************************/


#ifndef __BOARD_H
#define __BOARD_H


#include <bddefs.h>


#ifdef __cplusplus
extern "C" {
#endif

  
/* -----------------------------------------------------------------
 * Best Status Register Functions 
 * ----------------------------------------------------------------- */

CLI b_errtype EXPORT BestStatusRegGet(                             /* @sregget */
              b_handletype handle,
              b_int32      *value_ptr      /* #RETURN "status  =: %08lx\\h\n" */
              );


CLI b_errtype EXPORT BestStatusRegClear( /* @sregclear */
          b_handletype handle,
          b_int32      clearpattern  /* @clear */
          );


CLI b_errtype EXPORT BestBoardPropSet( /* @bdprpset */
              b_handletype    handle,
              b_boardproptype boardprop,  /* @prop */
              b_int32         value       /* @val */
              );


CLI b_errtype EXPORT BestBoardPropGet(    /* @bdprpget */
              b_handletype    handle,
              b_boardproptype boardprop,  /* @prop */
              b_int32        *value /* #RETURN "Boardproperty =: %x\\h\n" */
              );


CLI b_errtype EXPORT BestBoardPropDefaultSet (       /* @bdprpdefset */
              b_handletype  handle
	      );


CLI b_errtype EXPORT BestBoardPropStore( /* @bdprpstore */
              b_handletype    handle,
              b_boardproptype boardprop,  /* @prop */
              b_int32         value       /* @val */
              );


CLI b_errtype EXPORT BestBoardStoredPropGet(    /* @bdstoredprpget */
              b_handletype    handle,
              b_boardproptype boardprop,  /* @prop */
              b_int32        *value    /* #RETURN "Boardproperty =: %x\\h\n" */
              );


CLI b_errtype EXPORT BestSystemInfoGet(   /* @siget */
	      b_handletype      handle,      
	      b_systeminfotype  infoprop, /* @prop */
	      b_int32          *value     /* #RETURN "SystemInfo =: %u\n"  */
	      );

  
#ifdef __cplusplus
}
#endif


#endif

